<?php
/**
 * Project: MinervaKB.
 * Copyright: 2015-2017 @KonstruktStudio
 */

class MinervaKB_FeatureRequestsShortcode extends KST_Shortcode implements KST_Shortcode_Interface {

	protected $ID = 'feature-requests';
	protected $name = 'Feature Requests';
	protected $description = 'List of active Feature Requests';
	protected $icon = 'fa fa-thumbs-o-up';

	public function render($atts, $content = '') {
        $categories = array();

        if (isset($atts['categories']) && $atts['categories']) {
            $ids = explode(',', $atts['categories']);

            foreach ($ids as $id) {
                array_push($categories, get_term_by('id', (int)$id, 'mkb_feature_request_category'));
            }
        } else {
            $categories = get_terms( 'mkb_feature_request_category', array(
                'hide_empty' => true
            ));
        }

        if ( sizeof( $categories ) ):
            ?><div class="mkb-feature-requests-wrap"><?php

            foreach ( $categories as $term ):
                if (!$term) {
                    continue;
                }

                ?><div class="mkb-fr-category">
                    <div class="mkb-fr-category__name">
                        <i class="fa fa-folder"></i> <?php echo esc_html($term->name); ?>
                    </div>
                <?php

                $query_args = array(
                    'post_type' => 'mkb_feature_request',
                    'posts_per_page' => -1,
                    'ignore_sticky_posts' => 1,
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'mkb_feature_request_category',
                            'field'    => 'slug',
                            'terms'    => $term->slug
                        ),
                    )
                );

                if (MKB_Options::option( 'enable_fr_reorder' )) {
                    $query_args['meta_query'] = array(
                        'relation' => 'OR',
                        array('key' => 'mkb_tax_order_' . $term->term_id, 'compare' => 'EXISTS'),
                        array('key' => 'mkb_tax_order_' . $term->term_id, 'compare' => 'NOT EXISTS'),
                    );
                    $query_args['orderby'] = 'meta_value_num menu_order';
                    $query_args['order'] = 'ASC';
                } else {
                    $query_args['order'] = MKB_Options::option('fr_order');

                    $order_by = MKB_Options::option('fr_orderby');

                    if ($order_by === 'votes') {
                        $query_args['orderby'] = 'meta_value_num';
                        $query_args['meta_key'] = '_mkb_votes';
                    } else {
                        $query_args['orderby'] = $order_by;
                    }
                }

                $loop = new WP_Query( $query_args );

                if ( $loop->have_posts() ) :

                    ?><div class="mkb-fr-category__list"><?php

                    while ( $loop->have_posts() ) : $loop->the_post();

                        $post_id = get_the_ID();
                        $votes = (int)get_post_meta($post_id, '_mkb_votes', true);
                        $already_rated_cookie = 'mkb_feature_voted_' . $post_id;
                        $is_already_voted = isset($_COOKIE[$already_rated_cookie]) && $_COOKIE[$already_rated_cookie] == 1;

                        ?><div class="mkb-feature-request">
                        <div class="mkb-feature-request__title">
                            <?php the_title(); ?>
                        </div>
                        <div class="mkb-feature-request__description">
                            <?php the_content(); ?>
                        </div>
                        <div class="mkb-feature-request__actions">
                            <a href="#" class="js-mkb-vote-for-feature mkb-vote-for-feature<?php if ($is_already_voted) { echo ' state--voted'; } ?>" data-id="<?php echo esc_attr($post_id); ?>">
                                <i class="<?php MKB_TemplateHelper::option_icon_class('feature_requests_icon'); ?>"></i>
                            </a>
                            <span class="js-mkb-fr-votes-count mkb-fr-votes-count">
                                <?php echo esc_html($votes > 0 ? $votes : 0); ?>
                            </span>
                            <span class="js-mkb-fr-votes-count-text mkb-fr-votes-count-text">
                                <?php echo esc_html(MKB_Options::option($votes === 1 ?
                                    'feature_requests_vote_text' :
                                    'feature_requests_votes_text'
                                )); ?>
                            </span>
                        </div>
                        </div><?php

                    endwhile;

                    ?></div><?php
                endif;

                wp_reset_postdata();

                ?></div><?php
            endforeach;

            ?></div><?php

        endif;
	}
}